# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import SUCCESS_CODE, MESSAGE_CODE, request_valid, user_photo, stamp2datetime, datetime2stamp, \
    online_employee, interface_response, get_describe, SYSTEM_EXCEPTION, DATA_EXCEPTION, paging, date_period, \
    save_capture, monitor_data
import json
from django.utils.translation import ugettext_lazy as _


class BioTimeAppClockIn(object):

    """
    【Clock In】签到主界面
    """

    @request_valid
    @ladonize(long, str, str, str, str, str, str, int, str, str, str, rtype=str)
    def upload_transaction(self, punch_time, punch_type, work_code, capture, longitude, latitude, location, source, device_token, language, token):
        """
        上传考勤记录
        @param punch_time:      签到时间(stamp)
        @param punch_type:      签到事件(数据获取调用 BioTimeAppManualLog -> category)
        @param work_code:       工作代号(数据获取调用 BioTimeAppManualLog -> work_code)
        @param capture:         考勤照片 base64
        @param longitude:       经度(GPS)
        @param latitude:        纬度(GPS)
        @param location:        地址信息
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功:
                {"code": 1, "error": "", "describe": "", "message": "", "data":{"location":"位置信息", "punch_time":"签卡时间(stamp)"}}
            请求失败:
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.iclock.models.model_trans import Transaction
        from mysite import const
        from mysite.iclock.models.work_code import WorkCode
        from pytz import timezone, country_timezones

        import datetime
        # print "[*]Params:", location.decode('utf-8')
        if punch_time:
            if not longitude or not latitude:
                error = ''
                describe = 'Longitude or Latitude missing'
                message = _(u'GPS information is required')
                return interface_response(MESSAGE_CODE, '', error, describe, message)
            # print "[*]Latitude:{0} -- Longitude:{1}".format(float(latitude), float(longitude))
            # print "[*]Location:", location
            try:
                if source in (1, ):
                    location = json.loads(location)
                    country_code = location['CountryCode']
                    formattedaddresslines = location.get('FormattedAddressLines', None)
                    if formattedaddresslines:
                        location = ' - '.join(formattedaddresslines)
                else:
                    location = json.loads(location)
                    country_code = location[0]['mCountryCode']
                    location = location[0]['mAddressLines']['0']
            except Exception, e:
                error = ''
                describe = '{0}'.format(e)
                message = _(u'GPS invalid')
                return interface_response(MESSAGE_CODE, '', error, describe, message)
            emp = online_employee()
            stamp_punch_time = punch_time
            if country_code:
                # print "[*]Country Code:{0}".format(country_code)
                tzname = country_timezones[country_code]
                # print "[*]TZ Name:{0}".format(tzname)
                tz = timezone(tzname[0])
                local_time = datetime.datetime.now(tz)
                punch_time = stamp2datetime(stamp_punch_time, tz=tz)
                # print "[*]Country Location Time:", local_time
                local_time = local_time.replace(tzinfo=None)
                punch_time = punch_time.replace(tzinfo=None)
                # print "[*]Server Time:", local_time, punch_time
                transfer_time = (local_time - punch_time)
                transfer_time_seconds = abs(transfer_time.days * 24 * 60 * 60 + transfer_time.seconds)
                # print "[*]Transfer time:", transfer_time_seconds
                if transfer_time_seconds > 30:
                    message = u'Invalid punch time please try again'
                    return interface_response(MESSAGE_CODE, '', '', '', message)
            else:
                message = u'Invalid GPS Information'
                return interface_response(MESSAGE_CODE, '', '', '', message)
            if capture:
                try:
                    save_capture(emp, punch_time, capture)
                except Exception, e:
                    import traceback
                    traceback.print_exc()
                    message = u'Upload Failed'
                    return interface_response(MESSAGE_CODE, '', '', e, message)
            work_code = work_code.strip()
            if work_code:
                wcs = WorkCode.objects.filter(id=work_code)
                if wcs:
                    work_code = wcs[0].code
                else:
                    describe = u'Work code not found'
                    return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
            now = datetime.datetime.now()
            tsn = Transaction()
            tsn.PIN = emp.PIN
            tsn.TTime = punch_time
            tsn.WorkCode = work_code
            tsn.State = punch_type or 255
            tsn.longitude = longitude and float(longitude) or None
            tsn.latitude = latitude and float(latitude) or None
            tsn.location = u'{0}'.format(location.decode('utf-8'))
            tsn.data_from = const.MOBILE
            tsn.mobile = source
            tsn.upload_time = now
            tsn.save()
            try:
                monitor_data(emp.PIN, punch_time, punch_type, work_code, capture, longitude, latitude, location, source)
            except Exception, e:
                print e
            # print "[*]Return Data:", location
            return interface_response(SUCCESS_CODE, json.dumps({'location': location, 'punch_time': stamp_punch_time}), '', 'successful')
        else:
            describe = _(u'Punch time missing')
            message = _(u'Upload Failed')
            return interface_response(MESSAGE_CODE, '', '', describe, message)

    @request_valid
    @ladonize(long, int, str, str, str, rtype=str)
    def pull_transaction(self, current_day, source, device_token, language, token):
        """
        获取考勤记录
        @param current_day:    当前天(stamp)
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功:
                {"code": 1, "error": "", "describe": "", "message": "", "data":[{"punch_time": 1513699200, "punch_type": "0", "source": 3, "describe": "地址/设备序列号/补签卡"}, ]}
                source(考勤记录来源): (1, 设备), (2, 补签), (3, APP)
            请求失败:
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att.att_param import get_func_key
        # import datetime
        try:
            current_day = stamp2datetime(current_day)
            # next_day = current_day + datetime.timedelta(days=1)
            emp = online_employee()
            params = {'pin': emp.PIN, 'start': current_day.strftime('%Y-%m-%d'), 'end': current_day.strftime('%Y-%m-%d %H:%M:%S')}
            sql = get_sql('sql', sqlid='top3transaction', app="pywebsv", params=params)
            rows = p_query(sql)
            data = []
            if rows:
                choices = get_func_key()
                types = dict(choices)
                data = [{'punch_time': datetime2stamp(r[0]), 'punch_type':types.get(r[1], ''), 'source':r[4] or 1,
                        'describe': get_describe(r[4], r[5], r[6])} for r in rows]
            return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(str, long, int, int, str, str, str, rtype=str)
    def pull_all_transaction(self, pin, current_day, page_num, source, device_token, language, token):
        """
        获取考勤记录
        @param pin:                 工号，工号为空返回人员列表
        @param current_day:         当前天
        @param page_num:            页码
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            pin不为空时,请求成功
                {"code": 1,"error":"", "describe":"", "message":"", "data":[{"pin": "工号", "name":"姓名", "photo":"照片地址"}, ]}
            pin为空时,请求成功:
                {"code": 1,"error":"", "describe":"", "message":"", "data":[{"punch_time": "签卡时间(stamp)", "punch_type":"签卡时间", "source":1, "describe": "设备序列号"}, ]}
                source(考勤记录来源): (1, 设备), (2, 补签), (3, APP)
            请求失败:
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att.att_param import get_func_key
        from ordereddict import OrderedDict
        import datetime
        current_day = stamp2datetime(current_day)
        try:
            pin = pin.strip()
            previous_day = current_day + datetime.timedelta(days=-7)
            params = {
                'current_day': current_day.strftime('%Y-%m-%d %H:%M:%S'),
                'previous_day': previous_day.strftime('%Y-%m-%d %H:%M:%S'),
            }
            print "[*]Pin: {0} ---> {1}:{2}".format(
                pin, current_day.strftime('%Y-%m-%d'), previous_day.strftime('%Y-%m-%d'))
            if not pin:
                emp = online_employee()
                params['pin'] = emp.PIN
                sql = get_sql('sql', sqlid='transaction_employee', app="pywebsv", params=params)
                sql = paging(sql, page_num, 'pin')
                rows = p_query(sql)
                data = []
                if rows:
                    data = [{'pin': r[0], 'name': r[1], 'photo': user_photo(r[0])} for r in rows]
            else:
                params['pin'] = pin
                sql = get_sql('sql', sqlid='employee_transaction', app="pywebsv", params=params)
                sql = paging(sql, page_num, 'checktime')
                rows = p_query(sql)
                data = []
                # print "[*]Rows:", rows
                if rows:
                    choices = get_func_key()
                    types = dict(choices)
                    vals = OrderedDict()
                    for r in rows:
                        category = r[0].strftime('%Y-%m-%d')
                        if category not in vals:
                            vals[category] = []
                        item = {
                            'category': r[0].strftime('%Y-%m-%d'), 'punch_time': datetime2stamp(r[0]),
                            'punch_type': types.get(r[1], ''), 'source': r[4] or 1,
                            'describe': get_describe(r[4], r[5], r[6])
                        }
                        vals[category].append(item)
                    data = [{'category': key, 'items': val} for key, val in vals.iteritems()]
            return interface_response(SUCCESS_CODE, json.dumps(data), '', '')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(long, int, int, str, str, str, rtype=str)
    def pull_exception_summary(self, current_day, period, source, device_token, language, token):
        """
        获取考勤统计结果
        @param current_day:       当前时间
        @param period:            时间段(1：月 2：周)
        @param source:            数据来源(1: IOS， 2：Android)
        @param device_token:      消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1,"error":"",""describe:"","data":{"late_count":迟到次数,"early_leave_count":早退次数,"absent_count":旷工次数,"leave_count":请假次数,"overtime_count":加班次数,"current_day":当前天(stamp)}
            请求失败:
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.sql_utils import get_sql, p_query_one
        if period not in (1, 2):
            describe = 'period --> {0} error.'.format(period)
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        stamp_current = current_day
        current_day = stamp2datetime(stamp_current)
        if period in (1, ):
            start, end = date_period(6, current_day)
        elif period in (2, ):
            start, end = date_period(4, current_day)
        emp = online_employee()
        params = {'userid': emp.pk, 'start': start.strftime('%Y-%m-%d'), 'end': end.strftime('%Y-%m-%d')}
        sql = get_sql('sql', sqlid='attendance_summary', app="pywebsv", params=params)
        row = p_query_one(sql)
        data = row or (0, 0, 0, 0, 0)
        attendance = {
            'late_count': data[0],
            'early_leave_count': data[1],
            'absent_count': data[2],
            'leave_count': data[3],
            'overtime_count': data[4],
            'current_day': stamp_current
        }
        return interface_response(SUCCESS_CODE, json.dumps(attendance), '', 'successful')

